/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertAES;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWAdaptorControl;
import filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptorEx;
import filenet.vw.integrator.base.IVWAdaptorThread;
import filenet.vw.integrator.base.VWAdaptorEx;
import filenet.vw.integrator.base.VWResources;
import filenet.vw.server.VWCapsule;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class VWAdaptorControlEx
extends UnicastRemoteObject
implements IVWAdaptorControl {
    private AtomicInteger count = new AtomicInteger(0);
    protected DateFormat df = DateFormat.getDateTimeInstance(1, 1);
    private static final long serialVersionUID = 7449L;
    protected Date lastStartTime = null;
    protected Date lastStopTime = null;
    protected Vector adaptors = null;
    protected VWQueue queue = null;
    protected String username = null;
    protected String realPw = null;
    protected String queuename = null;
    protected String connection_point = null;
    protected int concurrent_threads = 1;
    protected String adaptor_class_name;
    protected int buffer_size = 5;
    protected String component_descriptor = null;
    protected WorkflowDispatcher workflow_dispatcher = null;
    protected VWXMLWrapper component_descriptor_doc = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.Dispatcher");
    protected String m_className = "VWAdaptorControlEx:";
    protected boolean is_web_services = false;
    private String m_name = null;
    private String m_adaptorCredPropertyName = null;

    protected String getLocaleDateStringNow() {
        return this.df.format(new Date());
    }

    public static String _get_FILE_DATE() {
        return "3/30/2011";
    }

    public static String _get_FILE_AUTHOR() {
        return "Quynh Dang";
    }

    public static String _get_FILE_REVISION() {
        return "scm952283/dts952264;";
    }

    public VWAdaptorControlEx(VWQueue queue, String component_descriptor) throws RemoteException {
        String m_method = "<init>";
        this.queuename = queue.toString();
        this.m_className = this.m_className + this.queuename;
        logger.entering(this.m_className, "<init>");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "<init>", "queue: " + queue + "comp. desc=" + component_descriptor);
        }
        try {
            this.queue = queue;
            this.component_descriptor = component_descriptor;
            this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
            this.connection_point = queue.getServiceSession().getConnectionPointName();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "<init>", e);
            throw new RemoteException("VWAdaptorControlEx::<init>", e);
        }
        finally {
            logger.exiting(this.m_className, "<init>");
        }
    }

    public VWAuthItem getPrivateCredentials() {
        VWAuthItem res;
        block4: {
            String m_method = "getPrivateCredentials";
            res = null;
            try {
                VWConvertAES aes;
                String s2 = this.getMyAdaptorCredentialPropertyName();
                String options = null;
                if (s2 != null) {
                    options = System.getProperty(s2);
                }
                if (options != null && (res = (aes = new VWConvertAES()).getDString(options)) != null && logger.isFinest()) {
                    logger.finest(this.m_className, "getPrivateCredentials", "Using private:" + res.getName());
                }
            }
            catch (Throwable t) {
                if (!logger.isFinest()) break block4;
                logger.throwing(this.m_className, "getPrivateCredentials", t);
            }
        }
        return res;
    }

    protected void getComponentParametersFromDescriptor() {
        String m_method = "getComponentParametersFromDescriptor";
        if (this.component_descriptor_doc == null) {
            return;
        }
        try {
            this.adaptor_class_name = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "adaptor_class");
            this.is_web_services = this.adaptor_class_name.indexOf("filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor") != -1;
            VWAuthItem itm = this.getPrivateCredentials();
            if (itm != null) {
                this.username = itm.getName();
                this.realPw = itm.getPassword();
            }
            if (this.username == null || this.realPw == null) {
                this.username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
                String password = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_password");
                VWCapsule capsule = new VWCapsule();
                capsule.setString(password);
                this.realPw = capsule.getString();
            }
            String ct = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "concurrent_threads");
            this.buffer_size = this.concurrent_threads = Math.max(1, Integer.parseInt(ct));
            try {
                ct = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "buffer_size");
                if (ct != null) {
                    this.buffer_size = Math.max(this.concurrent_threads, Integer.parseInt(ct));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String s = System.getProperty("filenet.pe.cm.buffer.size");
                if (s != null) {
                    this.buffer_size = Integer.parseInt(s);
                }
            }
            catch (Exception e) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    Vector getAdaptors() {
        return this.adaptors;
    }

    public String getName() throws RemoteException {
        if (this.m_name == null) {
            this.m_name = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "name");
        }
        return this.m_name;
    }

    protected String getMyAdaptorCredentialPropertyName() {
        if (this.m_adaptorCredPropertyName == null) {
            try {
                this.m_adaptorCredPropertyName = VWAdaptorControlEx.formAdaptorCredentialPropertyName(this.getName());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.m_adaptorCredPropertyName;
    }

    protected static String formAdaptorCredentialPropertyName(String adaptorName) {
        return "filenet.adaptors." + adaptorName + ".uid";
    }

    public String getComponentDescriptor() throws RemoteException {
        return this.component_descriptor;
    }

    public void setComponentDescriptor(String component_descriptor) throws RemoteException {
        String m_method = "setComponentDescriptor";
        logger.entering(this.m_className, "setComponentDescriptor");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "setComponentDescriptor", component_descriptor);
        }
        try {
            this.component_descriptor = component_descriptor;
            this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
            this.getComponentParametersFromDescriptor();
            if (this.is_web_services) {
                VWWebServicesAdaptorEx.PersistComponentDescriptor(component_descriptor);
            }
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "setComponentDescriptor", e);
            throw new RemoteException("VWAdaptorControlEx::setComponentDescriptor", e);
        }
        finally {
            logger.exiting(this.m_className, "setComponentDescriptor");
        }
    }

    public Date getLastStartTime() throws RemoteException {
        return this.lastStartTime;
    }

    public Date getLastStopTime() throws RemoteException {
        return this.lastStopTime;
    }

    public long getAverageCallsPerMinute() throws RemoteException {
        String m_method = "getAverageCallsPerMinute";
        long callsPerMinute = 0L;
        try {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                    callsPerMinute += adaptor.getAverageCallsPerMinute();
                }
            }
            long elements = callsPerMinute;
            return elements;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "getAverageCallsPerMinute", e);
            throw new RemoteException("VWAdaptorControlEx::getAverageCallsPerMinute", e);
        }
    }

    public long getAverageCallTimeMillis() throws RemoteException {
        String m_method = "getAverageCallTimeMillis";
        long result = 0L;
        try {
            long callTimeMillis = 0L;
            if (this.adaptors != null && this.adaptors.size() > 0) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                    callTimeMillis += adaptor.getAverageCallTimeMillis();
                }
                result = callTimeMillis / (long)this.adaptors.size();
            }
            long l = result;
            return l;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "getAverageCallTimeMillis", e);
            throw new RemoteException("VWAdaptorControlEx::getAverageCallTimeMillis", e);
        }
    }

    public void resetCallTimeStatistics() throws RemoteException {
        String m_method = "resetCallTimeStatistics";
        try {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                    adaptor.resetCallTimeStatistics();
                }
            }
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "resetCallTimeStatistics", e);
            throw new RemoteException("VWAdaptorControlEx::resetCallTimeStatistics", e);
        }
    }

    public boolean adaptorIsStarted() throws RemoteException {
        boolean isStarted = false;
        if (this.workflow_dispatcher != null) {
            isStarted = this.workflow_dispatcher.isRunning();
            return isStarted;
        }
        if (this.adaptors != null) {
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                if (!adaptor.isRunning()) continue;
                isStarted = true;
            }
        }
        return isStarted;
    }

    public String status() throws RemoteException {
        try {
            if (this.adaptors != null) {
                StringBuffer buf = new StringBuffer();
                if (this.workflow_dispatcher != null) {
                    buf.append(this.workflow_dispatcher.toString()).append("\n");
                }
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                    buf.append(adaptor.toString()).append("\n");
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VWResources.S_ADAPTORCONTROL_NOADAPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent() throws RemoteException {
        if (this.workflow_dispatcher != null) {
            WorkflowDispatcher workflowDispatcher = this.workflow_dispatcher;
            synchronized (workflowDispatcher) {
                this.workflow_dispatcher.notifyAll();
            }
        } else if (this.adaptors != null && this.adaptors.size() > 0) {
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                IVWAdaptorThread adaptor;
                IVWAdaptorThread iVWAdaptorThread = adaptor = (IVWAdaptorThread)elements.nextElement();
                synchronized (iVWAdaptorThread) {
                    adaptor.notifyAll();
                }
            }
        }
    }

    public void start() throws RemoteException {
        String m_method = "start";
        logger.entering(this.m_className, "start");
        this.getComponentParametersFromDescriptor();
        try {
            IVWAdaptorThread adaptor;
            this.stop();
            try {
                this.queue.getServiceSession().recoverUser(this.username, new String[]{this.queuename});
            }
            catch (Exception e) {
                logger.throwing(this.m_className, "start", e);
            }
            this.adaptors = new Vector();
            for (int i = 1; i <= this.concurrent_threads; ++i) {
                adaptor = null;
                adaptor = this.is_web_services ? new VWWebServicesAdaptorEx(this.queue, this.component_descriptor, i, this) : new VWAdaptorEx(this.queue, this.component_descriptor, i, this);
                this.adaptors.add(adaptor);
            }
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                adaptor = (IVWAdaptorThread)elements.nextElement();
                adaptor.setNameEx(adaptor.toString());
                adaptor.startEx();
            }
            this.workflow_dispatcher = new WorkflowDispatcher(this);
            this.workflow_dispatcher.start();
            this.lastStartTime = new Date();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "start", e);
            this.stop();
            throw new RemoteException("VWAdaptorControlEx::start", e);
        }
        logger.exiting(this.m_className, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws RemoteException {
        String m_method = "stop";
        logger.entering(this.m_className, "stop");
        try {
            if (this.workflow_dispatcher != null) {
                this.workflow_dispatcher.stopMe();
                this.workflow_dispatcher.join(5000L);
            }
            this.workflow_dispatcher = null;
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    IVWAdaptorThread adaptor = (IVWAdaptorThread)elements.nextElement();
                    adaptor.stopEx();
                    if (!(adaptor instanceof Thread)) continue;
                    ((Thread)((Object)adaptor)).join(5000L);
                }
                this.triggerEvent();
                Vector vector = this.adaptors;
                synchronized (vector) {
                    this.adaptors.removeAllElements();
                    this.adaptors = null;
                }
            }
            this.lastStopTime = new Date();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "stop", e);
            throw new RemoteException("VWAdaptorControlEx::stop", e);
        }
        logger.exiting(this.m_className, "stop");
    }

    public void refresh() throws RemoteException {
        if (this.is_web_services) {
            return;
        }
        String m_method = "refresh";
        logger.entering(this.m_className, "refresh");
        try {
            this.stop();
            this.component_descriptor_doc = null;
            VWQueueDefinition qdef = null;
            VWAttributeInfo attributes = null;
            if (this.queue != null) {
                qdef = this.queue.fetchQueueDefinition();
            }
            if (qdef != null) {
                attributes = qdef.getAttributeInfo();
            }
            if (attributes != null) {
                this.component_descriptor = (String)attributes.getFieldValue("F_ComponentDescriptor");
            }
            if (this.component_descriptor != null) {
                this.component_descriptor_doc = new VWXMLWrapper(this.component_descriptor);
            }
            if (this.component_descriptor_doc == null) {
                throw new RemoteException("VWAdaptorControlEx::refresh", new VWException("VWAdaptorControlEx.CouldNotRefreshDesc", "Failed to refresh component descriptor."));
            }
            this.start();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "refresh", e);
            throw new RemoteException("VWAdaptorControlEx::refresh", e);
        }
        logger.exiting(this.m_className, "refresh");
    }

    public VWQueue getQueue() {
        return this.queue;
    }

    public String toString() {
        return "VWAdaptorControlEx: queue=" + this.queuename + ", desc=" + this.component_descriptor;
    }

    class WorkflowDispatcher
    extends Thread {
        String m_className;
        boolean done;
        String m_status;
        private VWSession session;
        private VWQueue queue;
        private VWQueueDefinition qdef;
        private int workerIndex;
        VWAdaptorControlEx m_parent;

        public String toString() {
            return this.m_status;
        }

        protected boolean isRunning() {
            return !this.done;
        }

        protected void stopMe() {
            this.done = true;
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_className, VWAdaptorControlEx.this.getLocaleDateStringNow());
        }

        public WorkflowDispatcher(VWAdaptorControlEx parent) {
            this.m_className = "VWAdaptorControlEx.WorkflowDispatcher." + VWAdaptorControlEx.this.queuename + "." + VWAdaptorControlEx.this.username;
            this.done = false;
            this.session = null;
            this.queue = null;
            this.qdef = null;
            this.workerIndex = -1;
            this.m_parent = null;
            this.setName(this.m_className);
            this.m_parent = parent;
        }

        private long getNextWorkerTimeoutInMs() {
            return JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("filenet.pe.cm.adaptor.dispatcher.nextworker.timeout.in.seconds", 300L) * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IVWAdaptorThread getNextWorker() throws Throwable {
            String m_method = "getNextWorker";
            if (VWAdaptorControlEx.this.adaptors == null) {
                return null;
            }
            int myCount = 0;
            int nAdaptors = 0;
            int stuckIndex = -1;
            if (VWAdaptorControlEx.this.adaptors == null) {
                return null;
            }
            while (true) {
                Serializable serializable = VWAdaptorControlEx.this.adaptors;
                synchronized (serializable) {
                    IVWAdaptorThread adaptor;
                    ++this.workerIndex;
                    nAdaptors = VWAdaptorControlEx.this.adaptors.size();
                    if (this.workerIndex >= nAdaptors) {
                        this.workerIndex = 0;
                    }
                    if ((adaptor = (IVWAdaptorThread)VWAdaptorControlEx.this.adaptors.get(this.workerIndex)).isRunning() && adaptor.isIdle()) {
                        return adaptor;
                    }
                    if (adaptor.currentMethodExecutionTime() >= this.getNextWorkerTimeoutInMs()) {
                        stuckIndex = this.workerIndex;
                    }
                }
                if (++myCount != nAdaptors) continue;
                if (stuckIndex >= 0) {
                    serializable = VWAdaptorControlEx.this.adaptors;
                    synchronized (serializable) {
                        IVWAdaptorThread stuckAdaptor = (IVWAdaptorThread)VWAdaptorControlEx.this.adaptors.remove(stuckIndex);
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "getNextWorker", "Restarting out " + stuckAdaptor + ", STACK TRACE.." + Logger.traceSystem());
                        }
                        stuckAdaptor.stopEx();
                        stuckAdaptor = null;
                        VWAdaptorEx adaptor = null;
                        adaptor = VWAdaptorControlEx.this.is_web_services ? new VWWebServicesAdaptorEx(this.queue, VWAdaptorControlEx.this.component_descriptor, stuckIndex + 1, this.m_parent) : new VWAdaptorEx(this.queue, VWAdaptorControlEx.this.component_descriptor, stuckIndex + 1, this.m_parent);
                        VWAdaptorControlEx.this.adaptors.add(stuckIndex, adaptor);
                        adaptor.setNameEx(((Object)adaptor).toString());
                        adaptor.startEx();
                        return adaptor;
                    }
                }
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "getNextWorker", "Waiting for a free worker...");
                }
                serializable = this.m_parent;
                synchronized (serializable) {
                    this.m_parent.wait(30000L);
                }
                myCount = 0;
            }
        }

        private boolean hasWorker() {
            if (VWAdaptorControlEx.this.adaptors == null) {
                return false;
            }
            int nAdaptors = VWAdaptorControlEx.this.adaptors == null ? 0 : VWAdaptorControlEx.this.adaptors.size();
            for (int i = 0; i < nAdaptors; ++i) {
                IVWAdaptorThread adaptor = (IVWAdaptorThread)VWAdaptorControlEx.this.adaptors.get(i);
                if (!adaptor.isRunning()) continue;
                return true;
            }
            return false;
        }

        private void getSessionAndQueue() throws Throwable {
            this.session = new VWSession(VWAdaptorControlEx.this.username, VWAdaptorControlEx.this.realPw, VWAdaptorControlEx.this.connection_point);
            this.queue = this.session.getQueue(VWAdaptorControlEx.this.queuename);
            if (logger.isFinest()) {
                logger.finest(this.m_className, "getSessionAndQueue", "buffer_size=" + VWAdaptorControlEx.this.buffer_size);
            }
            this.queue.setBufferSize(VWAdaptorControlEx.this.buffer_size);
            this.qdef = this.queue.fetchQueueDefinition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String m_method = "run";
            logger.entering(this.m_className, m_method);
            try {
                this.getSessionAndQueue();
                if (!this.session.isMemberOfGroup("SysAdminG")) {
                    String[] readusers;
                    String[] writeusers = this.qdef.getWriteSecurity();
                    if (writeusers != null && writeusers.length > 0) {
                        boolean found = false;
                        boolean[] isgroup = this.session.fetchIsGroup(writeusers);
                        for (int i = 0; i < isgroup.length && !found; ++i) {
                            if (isgroup[i]) {
                                found = this.session.isMemberOfGroup(writeusers[i]);
                                continue;
                            }
                            if (!VWAdaptorControlEx.this.username.equals(writeusers[i])) continue;
                            found = true;
                        }
                        if (!found) {
                            VWException ex = new VWException("VWAdaptorControl.UserLacksWritePrivileges", "User {0} does not have write privileges to queue {1}.  Verify users privileges via the System Configuration application.", VWAdaptorControlEx.this.username, this.qdef.getName());
                            this.m_status = ex.getMessage();
                            logger.throwing(this.m_className, m_method, ex);
                            this.done = true;
                            return;
                        }
                    }
                    if ((readusers = this.qdef.getReadSecurity()) != null && readusers.length > 0) {
                        boolean found = false;
                        boolean[] isgroup = this.session.fetchIsGroup(readusers);
                        for (int i = 0; i < isgroup.length && !found; ++i) {
                            if (isgroup[i]) {
                                found = this.session.isMemberOfGroup(readusers[i]);
                                continue;
                            }
                            if (!VWAdaptorControlEx.this.username.equals(readusers[i])) continue;
                            found = true;
                        }
                        if (!found) {
                            VWException vwex = new VWException("VWAdaptorControl.UserLacksReadPrivileges", "User {0} does not have read privileges to queue {1}.  Verify users privileges via the System Configuration application.", VWAdaptorControlEx.this.username, this.qdef.getName());
                            this.m_status = vwex.getMessage();
                            logger.throwing(this.m_className, m_method, vwex);
                            this.done = true;
                            return;
                        }
                    }
                }
                String pr = VWXMLWrapper.getNodeValue(VWAdaptorControlEx.this.component_descriptor_doc.getRootNode(), "polling_rate");
                int polling_rate = 0;
                if (pr != null) {
                    polling_rate = Integer.parseInt(pr);
                }
                int initial_polling_rate = VWAdaptorControlEx.this.is_web_services ? (int)VWWebServicesAdaptorEx.GetPollingRate() : polling_rate;
                int max_polling_rate = VWAdaptorControlEx.this.is_web_services ? (int)VWWebServicesAdaptorEx.GetMaxPollingRate() : VWAdaptorEx.get_max_polling_rate(polling_rate);
                int polling_increment = VWAdaptorEx.get_polling_increment();
                String filter_string = VWAdaptorControlEx.this.is_web_services ? "(F_OperationId = 39 or F_OperationId = 41) and F_WsStatus = 0" : null;
                VWQueueQuery queue_query = null;
                boolean needToRecoverVWSession = false;
                String needToRecoverVWSessionReason = null;
                int exception_polling_interval = 15000;
                try {
                    String s = System.getProperty("filenet.PE.exception.polling.interval.ms");
                    if (s == null) {
                        s = System.getProperty("filenet.pe.cm.exception.polling.interval");
                    }
                    if (s != null) {
                        exception_polling_interval = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (logger.isFinest()) {
                    logger.finest(this.m_className, m_method, "Exception Polling Interval=" + exception_polling_interval);
                }
                while (!this.done) {
                    try {
                        if (needToRecoverVWSession) {
                            WorkflowDispatcher e = this;
                            synchronized (e) {
                                this.wait(exception_polling_interval);
                            }
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, m_method, "Attempt to recover VWSession, " + VWAdaptorControlEx.this.username + ", " + VWAdaptorControlEx.this.connection_point + " ,reason=" + needToRecoverVWSessionReason);
                            }
                            this.getSessionAndQueue();
                            needToRecoverVWSession = false;
                        }
                        boolean more_items_to_query = true;
                        block18: while (more_items_to_query && !this.done) {
                            block43: {
                                if (!this.hasWorker()) {
                                    this.done = true;
                                    break;
                                }
                                this.m_status = VWResources.VWS_WFDISPATCHER_RUN_STARTED.toString(VWAdaptorControlEx.this.getLocaleDateStringNow());
                                try {
                                    queue_query = this.queue.createQuery(null, null, null, 16, filter_string, null, 5);
                                    if (queue_query != null && queue_query.hasNext()) break block43;
                                    more_items_to_query = false;
                                    polling_rate = Math.min(max_polling_rate, polling_rate + polling_increment);
                                    break;
                                }
                                catch (VWException vwex) {
                                    String s = VWException.DescribeThrowableAndItsCauseWithStackFrames(vwex, 20);
                                    this.m_status = VWResources.VWS_WFDISPATCHER_QUERY_EXCEPTION.toString(new Object[]{VWAdaptorControlEx.this.getLocaleDateStringNow(), s});
                                    logger.severe(this.m_className, m_method, this.m_status);
                                    if (vwex.getLocalizedMessage().indexOf("21000012") < 0) break block43;
                                    this.done = true;
                                }
                                catch (Exception e) {
                                    needToRecoverVWSessionReason = VWException.DescribeThrowableAndItsCauseWithStackFrames(e, 20);
                                    this.m_status = VWResources.VWS_WFDISPATCHER_QUERY_EXCEPTION.toString(new Object[]{VWAdaptorControlEx.this.getLocaleDateStringNow(), needToRecoverVWSessionReason});
                                    logger.severe(this.m_className, m_method, this.m_status);
                                    needToRecoverVWSession = true;
                                    break;
                                }
                            }
                            while (queue_query.hasNext() && !this.done) {
                                polling_rate = initial_polling_rate;
                                IVWAdaptorThread worker = this.getNextWorker();
                                if (this.done) {
                                    this.m_status = VWResources.VWS_WFDISPATCHER_STOPPED.toString(VWAdaptorControlEx.this.getLocaleDateStringNow());
                                    continue;
                                }
                                if (worker != null) {
                                    worker.startWork((VWStepElement)queue_query.next());
                                    continue;
                                }
                                this.m_status = VWResources.VWS_WFDISPATCHER_NOWORKER.toString(VWAdaptorControlEx.this.getLocaleDateStringNow());
                                logger.severe(this.m_className, m_method, this.m_status);
                                this.done = true;
                                continue block18;
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.m_status = VWResources.VWS_WFDISPATCHER_FAILED.toString(new Object[]{this.m_status, VWException.DescribeThrowableAndItsCause(t)});
                        logger.severe(this.m_className, m_method, this.m_status);
                        if (t instanceof VWException) {
                            VWException vwex = (VWException)t;
                            if (vwex.getLocalizedMessage().indexOf("21000012") >= 0) {
                                this.done = true;
                                break;
                            }
                            needToRecoverVWSessionReason = this.m_status;
                            needToRecoverVWSession = true;
                        }
                        this.done = true;
                    }
                    if (this.done) continue;
                    this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING.toString(new Object[]{this.m_className, new Long(polling_rate), VWAdaptorControlEx.this.getLocaleDateStringNow()});
                    WorkflowDispatcher t = this;
                    synchronized (t) {
                        this.wait(polling_rate);
                    }
                }
                if (queue_query != null) {
                    while (queue_query.hasNext()) {
                        VWStepElement se = (VWStepElement)queue_query.next();
                        se.doAbort();
                    }
                }
                this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_className, VWAdaptorControlEx.this.getLocaleDateStringNow());
                if (logger.isFinest()) {
                    logger.finest(this.m_className, m_method, this.m_status);
                }
                if (this.session != null) {
                    this.session.logoff();
                }
            }
            catch (Throwable t) {
                String s;
                String cause = VWException.DescribeThrowableCompletely(t);
                this.m_status = s = VWResources.VWS_ADAPTOR_RUN_STOPPED_WITH_EX.toString(new Object[]{this.m_className, cause, this.m_status});
                logger.severe(this.m_className, m_method, this.m_status);
            }
            this.done = true;
            logger.exiting(this.m_className, m_method);
        }
    }
}

